* Poisson_fit.sas;
title 'Fitting the Poisson to frequency data';
data poisson;
	input y obsfreq;
	* Generate offset y values for plot;
	yexp = y - 0.1; yobs = y + 0.1;
	datalines;
0   6
1  15
2  17 
3  29
4  20
5   6
6   5
7   1
8   1
9   0
10  0
;
run;
* Print data set;
proc print data=poisson;
run;
* Descriptive statistics, save ybar, n, and var to data file;
proc univariate data=poisson;
	var y;
	histogram y / vscale=count;
	freq obsfreq;
	output out=stats mean=ybar n=n var=var;
run;
* Print output data file;
proc print data=stats;
run;
* Calculate expected frequencies using ybar;
data poisfit;
	if _n_ = 1 then set stats;
	set poisson;
	poisprob = pdf('poisson',y,ybar);
	expfreq = n*poisprob;
run;
* Print observed and expected frequencies;
proc print data=poisfit;
run;
* Plot observed and expected frequencies;
proc gplot data=poisfit;
	plot expfreq*yexp=1 obsfreq*yobs=2 / overlay legend=legend1 vref=0 wvref=3 
	vaxis=axis1 haxis=axis1;
	symbol1 i=needle v=circle c=red width=3 height=2;
	symbol2 i=needle v=square c=blue width=3 height=2;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
	legend1 label=(height=2) value=(height=2);
run;
quit;
